/*  Two videos in a window, 'd' key plays one, 'f' key is the other
 *
 *  original from Dan Shifman's processing Video Tutorial
 *   https://processing.org/tutorials/video/
 * 
 *  modified fred Wolflink @ MassArt 2/22/17
*/

import processing.video.*; 

// Step 1. Declare 2 Movie objects.
Movie movie1;
Movie movie2;
Movie nowPlaying;

void setup() {  
  size(320, 240);  

  // Step 2. Initialize Movie objects. The movie files should live in the data folder.
  movie1 = new Movie(this, "countdown.mov"); 
  movie2 = new Movie(this, "crashtest.mov");

  nowPlaying = movie1;  // need a movie to start with
}

void draw() {
  image(nowPlaying, 0, 0, width, height);
}

void keyPressed() {

  if (key == 'd') {
    nowPlaying.stop();     // stop the movie
    nowPlaying = movie1;   // switch movies
    nowPlaying.loop();     // loop it
  }
  if (key == 'f') {
    nowPlaying.stop();
    nowPlaying = movie2;
    nowPlaying.loop();
  }
}

void movieEvent(Movie m) {
  m.read();
}